<?php
require_once 'admin_config.php';
requireAdmin();

if (!isset($_GET['id'])) {
    header('Location: dashboard.php');
    exit();
}

$user_id = $_GET['id'];
$user = callAPI('admin/users/' . $user_id);
$transactions = callAPI('admin/users/' . $user_id . '/transactions');

require_once '../header.php';
?>

<div class="container bg-dark text-white mt-5">
    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">معلومات المستخدم</h5>
                </div>
                <div class="card-body">
                    <p><strong>الاسم:</strong> <?php echo htmlspecialchars($user['name']); ?></p>
                    <p><strong>البريد الإلكتروني:</strong> <?php echo htmlspecialchars($user['email']); ?></p>
                    <p><strong>تاريخ التسجيل:</strong> <?php echo htmlspecialchars($user['created_at']); ?></p>
                    <p><strong>الرصيد الحالي:</strong> <?php echo htmlspecialchars($user['balance']); ?> $</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">معاملات المستخدم</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>التاريخ</th>
                                    <th>النوع</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($transactions as $transaction): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($transaction['date']); ?></td>
                                    <td><?php echo htmlspecialchars($transaction['type']); ?></td>
                                    <td><?php echo htmlspecialchars($transaction['amount']); ?> $</td>
                                    <td>
                                        <span class="badge bg-<?php echo $transaction['status'] === 'completed' ? 'success' : 'warning'; ?>">
                                            <?php echo htmlspecialchars($transaction['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($transaction['status'] === 'pending'): ?>
                                        <form method="POST" action="approve-transaction.php" class="d-inline">
                                            <input type="hidden" name="transaction_id" value="<?php echo $transaction['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-success">موافقة</button>
                                        </form>
                                        <form method="POST" action="reject-transaction.php" class="d-inline">
                                            <input type="hidden" name="transaction_id" value="<?php echo $transaction['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger">رفض</button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?> 